/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.version;

import frc.emul.config.ConfigLoader;
import frc.emul.vectrex.ui.Browser;
import frc.emul.version.Version;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class VersionChecker
implements ContentHandler,
ErrorHandler {
    private boolean aborted;
    private List<String> stack = new ArrayList<String>();
    private Locator locator;
    private String errorMsg;
    private boolean goodTarget;
    private Integer vMajor;
    private Integer vMinor;
    private Integer vRev;
    private Integer vBuild;
    private String vDate;
    private String updateURL;

    public void abort() {
        this.aborted = true;
    }

    public synchronized Boolean check(String string) {
        Boolean bl;
        block11: {
            InputStream inputStream = null;
            try {
                URL uRL = Browser.getEncodedURL(string);
                inputStream = uRL.openStream();
            }
            catch (MalformedURLException malformedURLException) {
                return this.setError("The version descriptor's URL is malformed", malformedURLException);
            }
            catch (UnknownHostException unknownHostException) {
                return this.setError("Could not connect to the version descriptor's host", unknownHostException);
            }
            catch (Exception exception) {
                return this.setError("Could not access to the latest version descriptor", exception);
            }
            try {
                bl = this.check(inputStream);
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    /*
     * Loose catch block
     */
    public synchronized Boolean check(InputStream inputStream) {
        if (inputStream == null) {
            return this.setError("Could not access to the latest version descriptor");
        }
        if (this.aborted) {
            return this.setError("Aborted by user");
        }
        XMLReader xMLReader = null;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        xMLReader = sAXParser.getXMLReader();
        xMLReader.setContentHandler(this);
        xMLReader.setErrorHandler(this);
        xMLReader.parse(ConfigLoader.openInputSource(inputStream));
        Boolean bl = this.check();
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        return bl;
        catch (Throwable throwable) {
            block15: {
                Boolean bl2;
                try {
                    if (xMLReader != null) break block15;
                    bl2 = this.setError("Failed to instanciate an XML reader for the version descriptor", throwable);
                }
                catch (Throwable throwable2) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                    throw throwable2;
                }
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                return bl2;
            }
            Boolean bl3 = this.setError("Failed to download the latest version descriptor", throwable);
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            return bl3;
        }
    }

    private Boolean check() {
        if (this.aborted) {
            return this.setError("Aborted by user");
        }
        if (this.vMajor == null) {
            return this.setError("Cannot find the major version number in the version descriptor");
        }
        if (this.vMinor == null) {
            return this.setError("Cannot find the minor version number in the version descriptor");
        }
        if (this.vRev == null) {
            return this.setError("Cannot find the revision number in the version descriptor");
        }
        if (this.vBuild == null) {
            return this.setError("Cannot find the build number in the version descriptor");
        }
        int n = this.vMajor;
        if (n > 0) {
            return Boolean.FALSE;
        }
        if (n < 0) {
            return Boolean.TRUE;
        }
        int n2 = this.vMinor;
        if (n2 > 7) {
            return Boolean.FALSE;
        }
        if (n2 < 7) {
            return Boolean.TRUE;
        }
        int n3 = this.vRev;
        if (n3 > 0) {
            return Boolean.FALSE;
        }
        if (n3 < 0) {
            return Boolean.TRUE;
        }
        return this.vBuild > 101229 ? Boolean.FALSE : Boolean.TRUE;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("build")) {
            this.goodTarget = this.checkOsTarget(attributes == null ? null : attributes.getValue("targets"));
        } else if (attributes != null && this.getParentItem(1).equalsIgnoreCase("build.1") && this.goodTarget) {
            if (string3.equals("version")) {
                this.vMajor = this.getIntValue(attributes, "major");
                this.vMinor = this.getIntValue(attributes, "minor");
                this.vRev = this.getIntValue(attributes, "revision");
                this.vBuild = this.getIntValue(attributes, "build");
                this.vDate = attributes.getValue("date");
            }
            if (string3.equals("links")) {
                this.updateURL = attributes.getValue("update_url");
                if (this.updateURL != null) {
                    this.updateURL = this.updateURL.replaceAll("\\$VERSION\\$", Version.sSHORT).replaceAll("\\$BUILD\\$", Version.sBUILD);
                }
            }
        }
        String string4 = attributes == null ? null : attributes.getValue("format");
        String string5 = string4 == null ? string3 : String.valueOf(string3) + "." + string4;
        this.stack.add(string5);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.stack.remove(this.stack.size() - 1);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void warning(SAXParseException sAXParseException) {
        System.err.println("*** " + this.appendLocation("Version file parsing warning"));
        sAXParseException.printStackTrace(System.err);
    }

    public void error(SAXParseException sAXParseException) {
        System.err.println("*** " + this.appendLocation("Version file parsing error"));
        sAXParseException.printStackTrace(System.err);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.err.println("*** " + this.appendLocation("FATAL ERROR during version file parsing"));
        sAXParseException.printStackTrace(System.err);
        throw new RuntimeException("Version file parsing fatal error");
    }

    private final String appendLocation(String string) {
        if (this.locator == null) {
            return String.valueOf(string) + " at undefined location.";
        }
        return String.valueOf(string) + " at line " + this.locator.getLineNumber() + ", column " + this.locator.getColumnNumber() + ".";
    }

    private Boolean setError(String string) {
        return this.setError(string, null);
    }

    private Boolean setError(String string, Throwable throwable) {
        this.errorMsg = string;
        System.err.println(string);
        if (throwable != null) {
            throwable.printStackTrace(System.err);
        }
        return null;
    }

    private String getParentItem(int n) {
        int n2 = this.stack.size();
        return n > n2 ? "" : this.stack.get(n2 - n);
    }

    private Integer getIntValue(Attributes attributes, String string) {
        try {
            return new Integer(attributes.getValue(string));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean checkOsTarget(String string) {
        if (string == null) {
            return false;
        }
        if ((string = "," + string + ",").indexOf(",*,") >= 0) {
            return true;
        }
        String string2 = System.getProperty("os.name").toLowerCase();
        if (string2.startsWith("windows")) {
            return string.indexOf(",windows,") >= 0;
        }
        if (string2.startsWith("mac")) {
            return string.indexOf(",mac,") >= 0;
        }
        return string.indexOf(",linux,") >= 0;
    }

    public String getError() {
        return this.errorMsg;
    }

    public String getNewVersionUpdateURL() {
        return this.updateURL == null || "".equals(this.updateURL.trim()) ? null : this.updateURL;
    }

    public String getNewVersionFullNumber() {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(this.vMajor).append('.').append(this.vMinor).append('.').append(this.vRev).append('.').append(this.vBuild);
        return stringBuffer.toString();
    }

    public String getNewVersionReleaseDate() {
        if (this.vDate == null) {
            return null;
        }
        try {
            int n = this.vDate.indexOf(47);
            int n2 = this.vDate.lastIndexOf(47);
            int n3 = Integer.parseInt(this.vDate.substring(0, n));
            int n4 = Integer.parseInt(this.vDate.substring(n + 1, n2));
            int n5 = Integer.parseInt(this.vDate.substring(n2 + 1));
            GregorianCalendar gregorianCalendar = new GregorianCalendar(n5, n4 - 1, n3);
            DateFormat dateFormat = DateFormat.getDateInstance(0);
            return dateFormat.format(gregorianCalendar.getTime());
        }
        catch (Exception exception) {
            System.err.println("Non fatal error while parsing the new version release date [" + this.vDate + "]");
            return null;
        }
    }
}

